/* FREIGHT DEMAND MODEL */
/* Freight demand is modelled based on gdp growth by industry (i), freight */
/* intensity by industry (tkm), mode shares (m) and industry by region */
/* (yielding a distance/km multiplier for marginal shares). */
mata
/* DIMENSIONS */
/*DIMENSIONS*/
/*Projection length, periods*/
Ps = 2021
Pe = 2050
/*Projection_t = 2021:2050
//Length of historical data series*/
Ts = 1992
Te = 2020
/*Set population series length, history plus projection
*Time_t = 1992:2050*/
Time_length = Pe - Ts + 1
TL = Time_length
Time_t = 1992..2050
/*Length of history
*History_length = length(History_t)*/
History_length = Te - Ts+1
HL = History_length

/*Length of projection
//Projection_length = length(Projection_t)*/
Projection_length = Pe - Ps + 1

NLTDM_Ind = 1..9 /*Industries, includes Unallocated */
NLTDM_Ind_n = length(NLTDM_Ind)
Freight_ind = 1..8 /*Excludes Unallocated */
Freight_ind_n = length(Freight_ind)
Reg_n = (1..12)
Regl = length(Reg_n)

/* INITIALISE */
/* Relationship between road freight volumes and tonne-km (MoT data) */
road_tkm_c = 1937.17708356781
road_tkm_b = 3.75893534291922


/* Freight indices*/
freight_gdp_ind_vol_fcast = (freight_ind_vol_gdp\J(Projection_length,NLTDM_Ind_n,0)) /*DELETED Projection length adjustment (PLA) */
freight_reg_ind_gdp = J(Time_length,Freight_ind_n*Regl,0)
freight_reg_ind_gdp_growth = J(Time_length,Freight_ind_n*Regl,0)
ind_roadfreight_vol_fcast = (ind_roadfreight_vol\J(Projection_length,NLTDM_Ind_n,0))
ind_railfreight_vol_fcast = (ind_railfreight_vol\J(Projection_length,NLTDM_Ind_n,0))
ind_seafreight_vol_fcast = (ind_seafreight_vol\J(Projection_length,NLTDM_Ind_n,0))
ind_roadfreight_intensity = ind_roadfreight_vol:/freight_ind_vol_gdp[1..History_length,.]
ind_railfreight_intensity = ind_railfreight_vol:/freight_ind_vol_gdp[1..History_length,.]
ind_seafreight_intensity = ind_seafreight_vol:/freight_ind_vol_gdp[1..History_length,.]
ind_roadfreight_intensity_fcast = (ind_roadfreight_intensity\J(Projection_length,NLTDM_Ind_n,0))
ind_railfreight_intensity_fcast = (ind_railfreight_intensity\J(Projection_length,NLTDM_Ind_n,0))
ind_seafreight_intensity_fcast = (ind_seafreight_intensity\J(Projection_length,NLTDM_Ind_n,0))
roadfreight_tkm_fcast = (roadfreight_tkm\J(Projection_length,1,0))
reg_roadfreight_ind_fcast = J(Time_length,Freight_ind_n*Regl,0)
reg_railfreight_ind_fcast = J(Time_length,Freight_ind_n*Regl,0)
reg_seafreight_ind_fcast = J(Time_length,Freight_ind_n*Regl,0)

/* Note that the dist_coeff_fcast matrix is (TL x regl) x Industries */
dist_coeff_fcast = J(rows(reg_dist_coeff)*Time_length,cols(reg_dist_coeff),0)
for (i=1;i<=Regl;i++){
	dist_coeff_fcast[(i-1)*TL+1..(i)*TL,.] = J(TL,1,reg_dist_coeff[i,.])
	}
/*dist_coeff_fcast = repmat(TL, 1, dist_coeff_fcast)  for the time being these are constants as I have only one year of data to gauge distance coefficients - from Paling 2008 */

	ind_roadfreight_intensity_growth = (ag_roadfreight_intensity_growth,for_roadfreight_intensity_growth,min_roadfreight_intensity_growth,othm_roadfreight_intensity_gr,cons_roadfreight_intensity_gr,trad_roadfreight_intensity_gr,oths_roadfreight_intensity_gr,pub_roadfreight_intensity_gr,0)
	ind_railfreight_intensity_growth = (ag_railfreight_intensity_growth,for_railfreight_intensity_growth,min_railfreight_intensity_growth,othm_railfreight_intensity_gr,cons_railfreight_intensity_gr,trad_railfreight_intensity_gr,oths_railfreight_intensity_gr,pub_railfreight_intensity_gr,0)
	ind_seafreight_intensity_growth = (ag_seafreight_intensity_growth,for_seafreight_intensity_growth,min_seafreight_intensity_growth,othm_seafreight_intensity_gr,cons_seafreight_intensity_gr,trad_seafreight_intensity_gr,oths_seafreight_intensity_gr,pub_seafreight_intensity_gr,0)


/* PROJECT NATIONAL DEMAND */

/* Construct freight relevant GDP forecasts using matrix providing correspondence between forecasts of industry GDP anbd the frieght industry GDP categories */
freight_gdp_ind_vol_growth = gdp_ind_vol_fcast*freight_gdp_corresp
freight_gdp_ind_vol_growth[2..rows(freight_gdp_ind_vol_growth),.] =  diff(freight_gdp_ind_vol_growth):/freight_gdp_ind_vol_growth[1..Time_length-1,.]

/*Calibrate the growth rate*/
freight_gdp_ind_vol_growth[31,.]=(freight_gdp_ind_vol_growth[30,.] :+ freight_gdp_ind_vol_growth[32,.]):/2

/* Project freight relevant GDP */
for (i = 23; i<=Time_length; i++) {
    freight_gdp_ind_vol_fcast[i,.] = freight_gdp_ind_vol_fcast[i-1,.]:*(1:+freight_gdp_ind_vol_growth[i,.])
}

/* Freight volumes */
for (i=21; i<=TL; i++) {
ind_roadfreight_intensity_fcast[i,.] = ind_roadfreight_intensity_fcast[i-1,.]:*ind_roadfreight_intensity_growth
ind_railfreight_intensity_fcast[i,.] = ind_railfreight_intensity_fcast[i-1,.]:*ind_railfreight_intensity_growth
ind_seafreight_intensity_fcast[i,.] = ind_seafreight_intensity_fcast[i-1,.]:*ind_seafreight_intensity_growth
ind_roadfreight_vol_fcast[i,.] = ind_roadfreight_intensity_fcast[i,.]:*freight_gdp_ind_vol_fcast[i,.]
ind_railfreight_vol_fcast[i,.] = ind_railfreight_intensity_fcast[i,.]:*freight_gdp_ind_vol_fcast[i,.]
ind_seafreight_vol_fcast[i,.] = ind_seafreight_intensity_fcast[i,.]:*freight_gdp_ind_vol_fcast[i,.]
}
roadfreight_vol_fcast = rowsum(ind_roadfreight_vol_fcast)
railfreight_vol_fcast = rowsum(ind_railfreight_vol_fcast)
seafreight_vol_fcast = rowsum(ind_seafreight_vol_fcast)

freight_vol_fcast = roadfreight_vol_fcast + railfreight_vol_fcast + seafreight_vol_fcast
roadfreight_vol_share = roadfreight_vol_fcast:/freight_vol_fcast

seafreight_vol_share = seafreight_vol_fcast:/freight_vol_fcast
railfreight_vol_share = railfreight_vol_fcast:/freight_vol_fcast

roadfreight_vol_growth = J(TL,1,0)
roadfreight_vol_growth[2..rows(roadfreight_vol_growth)]= diff(roadfreight_vol_fcast):/roadfreight_vol_fcast[1..Time_length-1]

freight_intensity = freight_vol_fcast:/gdp_vol_fcast


/* Tonne kilometres equivalents of the volume forecast */
roadfreight_tkm_fcast[History_length..rows(roadfreight_tkm_fcast),.] = road_tkm_c :+ (road_tkm_b:*roadfreight_vol_fcast[History_length..rows(roadfreight_vol_fcast),.])
roadfreight_tkm_growth = J(TL,1,0)
roadfreight_tkm_growth[2..rows(roadfreight_tkm_growth)]= diff(roadfreight_tkm_fcast):/roadfreight_tkm_fcast[1..Time_length-1]  


/* PROJECT REGIONAL DEMAND */
/* Based on industry GDP, freight intensities, and distance */
/* multipliers/coefficients */
/*Construct freight relevant regional GDP forecasts using matrix providing correspondence between forecasts of industry GDP anbd the frieght industry GDP categories */

for (i = 1; i<=Regl; i++) {
freight_reg_ind_gdp[1..History_length,(i-1)*Freight_ind_n +1..(i)*Freight_ind_n] = freight_reg_ind_gdp_shr[(i-1)*Freight_ind_n +1..(i)*Freight_ind_n,.]':*freight_gdp_ind_vol_fcast[1..History_length,1.. Freight_ind_n]
}


		for (i=1; i<=Regl; i++){
		freight_reg_ind_gdp_growth[.,(i-1)*Freight_ind_n +1..(i)*Freight_ind_n] = reg_ind_gdp[.,(i-1)*16+1..(i)*16] * freight_gdp_corresp[1..16,1..8]
		}

freight_reg_ind_gdp_growth[2..rows(freight_reg_ind_gdp_growth),.] =  diff(freight_reg_ind_gdp_growth):/freight_reg_ind_gdp_growth[1..Time_length-1,.]

for (i=30; i<=Time_length; i++){
freight_reg_ind_gdp[i,.] = freight_reg_ind_gdp[i-1,.]:*(1:+freight_reg_ind_gdp_growth[i,.])
}

for (i=1; i<=12; i++){
	reg_roadfreight_ind_fcast[.,(i-1)*Freight_ind_n +1..(i)*Freight_ind_n] = freight_reg_ind_gdp[.,(i-1)*Freight_ind_n +1..(i)*Freight_ind_n]:*ind_roadfreight_intensity_fcast[.,1..8]:*dist_coeff_fcast[(i-1)*TL +1..(i)*TL,.]
reg_railfreight_ind_fcast[.,(i-1)*Freight_ind_n +1..(i)*Freight_ind_n] = freight_reg_ind_gdp[.,(i-1)*Freight_ind_n +1..(i)*Freight_ind_n]:*ind_railfreight_intensity_fcast[.,1..8]:*dist_coeff_fcast[(i-1)*TL +1..(i)*TL,.]
reg_seafreight_ind_fcast[.,(i-1)*Freight_ind_n +1..(i)*Freight_ind_n] = freight_reg_ind_gdp[.,(i-1)*Freight_ind_n +1..(i)*Freight_ind_n]:*ind_seafreight_intensity_fcast[.,1..8]:*dist_coeff_fcast[(i-1)*TL +1..(i)*TL,.]
}
reg_roadfreight_fcast = J(TL,Regl,0)
reg_railfreight_fcast = J(TL,Regl,0)
reg_seafreight_fcast = J(TL,Regl,0)

for (i=1; i<=12; i++){
reg_roadfreight_fcast[.,i] = rowsum(reg_roadfreight_ind_fcast[.,(i-1)*Freight_ind_n +1..(i)*Freight_ind_n])
reg_railfreight_fcast[.,i] = rowsum(reg_railfreight_ind_fcast[.,(i-1)*Freight_ind_n +1..(i)*Freight_ind_n])
reg_seafreight_fcast[.,i] = rowsum(reg_seafreight_ind_fcast[.,(i-1)*Freight_ind_n +1..(i)*Freight_ind_n])
}

/* Origin-destination model*/ 
f_r = 12
f_t = TL
model2geo = (1,2,3,4,11,5,6,7,12,8,9,10)

/*Prep predictors*/
MANU_modelreg_rt = J(12,59,0)
PRIM_modelreg_rt = J(12,59,0)
reg_ind_gdp_SERV = J(12,59,0)
SERV_modelreg_rt = J(12,59,0)

	for (i=1; i<=12; i++){
		MANU_modelreg_rt[i,.] = reg_ind_gdp[.,(i-1)*Indx_n+3]':+reg_ind_gdp[.,(i-1)*Indx_n+5]':+reg_ind_gdp[.,(i-1)*Indx_n+8]'
		PRIM_modelreg_rt[i,.] = reg_ind_gdp[.,(i-1)*Indx_n+1]':+reg_ind_gdp[.,(i-1)*Indx_n+2]'
		reg_ind_gdp_SERV[i,.] = reg_ind_gdp[.,(i-1)*Indx_n+9]'
		SERV_modelreg_rt[i,.] = reg_ind_gdp[.,(i-1)*Indx_n+4]':+reg_ind_gdp[.,(i-1)*Indx_n+6]'
	}
		SERV_modelreg_rt= SERV_modelreg_rt:+colsum(reg_ind_gdp_SERV)

TOT_modelreg_rt = MANU_modelreg_rt + PRIM_modelreg_rt + SERV_modelreg_rt
POP_modelreg_rt = pop_by_reg'

MANU_rt = J(12,59,0)
PRIM_rt = J(12,59,0)
SERV_rt = J(12,59,0)
TOT_rt = J(12,59,0)
POP_rt = J(12,59,0)

for (i = 1; i<=12; i++){
MANU_rt[i,.] = MANU_modelreg_rt[model2geo[1,i],.] 
PRIM_rt[i,.] = PRIM_modelreg_rt[model2geo[1,i],.]
SERV_rt[i,.] = SERV_modelreg_rt[model2geo[1,i],.]
TOT_rt[i,.] = TOT_modelreg_rt[model2geo[1,i],.]
POP_rt[i,.] = POP_modelreg_rt[model2geo[1,i],.]
}

OwnServShr_t = J(f_r*f_r,f_t,0)
OwnPop_t = J(f_r*f_r,f_t,0)
OwnGDP_t = J(f_r*f_r,f_t,0)
for (i = 1; i<=f_r; i++){
	for (j = 1; j<=f_t; j++){
		OwnServShr_t[i+12*(i-1),j] = SERV_rt[i,j]:/TOT_rt[i,j]
		OwnPop_t[i+12*(i-1),j] = POP_rt[i,j]
		OwnGDP_t[i+12*(i-1),j] = TOT_rt[i,j]
	}
}

AREA_rt = J(1,f_t,Area)
TRADEVOL_rt = (XVOL_rt,J(f_r,Projection_length+6,0))
for (i = rows(XVOL_rt)+1; i<=Time_length; i++){
	TRADEVOL_rt[.,i] = (TOT_rt[.,i]:/TOT_rt[.,i-1]):*TRADEVOL_rt[.,i-1]
} 

IM = 1:-I(12)
IMUL = rowshape(IM,1)
tkm_rho = 0.11
trate_rho = 0.137
tkm_fit_level_t = J(144,59,0)
t_fit_level_t = J(144,59,0)
tkm_rate_fit_t = J(144,59,0)
t_rate_fit_t = J(144,59,0)


for (i = 1; i<=TL; i++){
    AREA = AREA_rt[.,i]
    MANU = MANU_rt[.,i]
    SERV = SERV_rt[.,i]
    PRIM = PRIM_rt[.,i]
    TOT = TOT_rt[.,i]
    POP = POP_rt[.,i]
    TRADEVOL = TRADEVOL_rt[.,i]
    OwnServShr = OwnServShr_t[.,i]
    OwnPop = OwnPop_t[.,i]
    OwnGDP = OwnGDP_t[.,i]
    /*Fit OD flows*/
    i_n = J(rows(W_contig),1,1)
    I_n = I(12)
    /*Distances*/
    D = rowshape(Dist,1)
    /*Get Weights matrix/matrices*/
    W_o = I_n#W_contig
    W_d = W_contig#I_n
    W_od = W_contig#W_contig
    W_j = W_o + W_d + W_od
    W_k = W_o + W_d
    /*Get a per GDP dependent variable*/
    y_denom = TOT#i_n
    /*Form predictor values*/
    /*Manufacturing GDP*/
    Xmanu_o = log(i_n#MANU)
    Xmanu_d = log(MANU#i_n)
    /*Service sector GDP*/
    Xserv_o = log(i_n#SERV)
    Xserv_d = log(SERV#i_n)
    /*Primary sector GDP*/
    Xprim_o = log(i_n#PRIM)
    Xprim_d = log(PRIM#i_n)
    /*Population*/
    Xpop_o = log(i_n#POP)
    Xpop_d = log(POP#i_n)
    /*Total GDP*/
    Xgdp_o = log(i_n#TOT)
    Xgdp_d = log(TOT#i_n)
    /*GDP shares*/
    /*Manufacturing GDP share*/
    Xmanushr_o = log(i_n#(MANU:/TOT))
			Xmanushr_d = log((MANU:/TOT)#i_n)
Xmanushr_d = editmissing(Xmanushr_d,0)
    /*Service sector GDP share*/
    Xservshr_o = log(i_n#(SERV:/TOT))
			Xservshr_d = log((SERV:/TOT)#i_n)
			Xservshr_d=editmissing(Xservshr_d,0)
    /*Primary sector GDP share*/
    Xprimshr_o = log(i_n#(PRIM:/TOT))
			Xprimshr_d = log((PRIM:/TOT)#i_n)
			Xprimshr_d = editmissing(Xprimshr_d,0)
    /*Area*/
    Xarea_d = log(AREA#i_n)
    Xarea_o = log(i_n#AREA)
    /*Export+import TRADE volumes*/
    Xvol_d = log(TRADEVOL#i_n)
    Xvol_o = log(i_n#TRADEVOL)
	Xvol_d=editmissing(Xvol_d,0)
    /*IntraRegional_Predictors*/
    Xintraregrate =(log((OwnGDP:/OwnPop)*1000000),log(OwnServShr))
				Xintraregrate=editmissing(Xintraregrate,0)
    /*Interegional constant*/
    c = J(rows(Xpop_o),1,1)
    X_rate = (c, Xservshr_d,Xservshr_o,Xprimshr_d,Xvol_o,Xpop_d,Xpop_o,Xgdp_d,Xarea_o,log(D)'):*IMUL'
    /*Remove own area covariates 
 		   X_rate(D==0,1..end)=0*/
    /*Add intra regional predictors*/

    X_rate = (X_rate,Ownc,Xintraregrate)
    /*Fitted values*/
	A1 = X_rate*tkm_beta
	A1 = editmissing(A1,0)
	A2 = I(rows(W_j)) :- tkm_rho*W_j
    tkm_rate_fit = svsolve(A1,A2)'
	B1 = X_rate*tkm_beta
	B1= editmissing(B1,0)
	B2 = I(rows(W_j))- trate_rho:*W_j
    t_rate_fit =  svsolve(B1,B2)'
    tkm_fit_level = exp(tkm_rate_fit):*y_denom
    t_fit_level = exp(t_rate_fit):*y_denom
    tkm_fit_level_t[.,i]=tkm_fit_level
    t_fit_level_t[.,i]=t_fit_level
    tkm_rate_fit_t[.,i]= tkm_rate_fit
    t_rate_fit_t[.,i]= t_rate_fit
}
/* mldivide() converted to svsolve() */
/*
for (i = 1; i<=f_t; i++){
    od_tkm_fit[.,:,i] = reshape(tkm_fit_level_t[.,i),12,12);
    od_t_fit[.,:,i] = reshape(t_fit_level_t[.,i),12,12);
}
    
for (i = 1; i<=TL; i++){
    out_tkm_fit[.,i] = squeeze(sum(od_tkm_fit[.,:,i),2));
    out_t_fit[.,i] = squeeze(sum(od_t_fit[.,:,i),2));
}

for (i = 1; i<=TL; i++){
    in_tkm_fit[.,i) = squeeze(sum(od_tkm_fit[.,:,i),1));
    in_t_fit[.,i) = squeeze(sum(od_t_fit[.,:,i),1));
}


tkm_fit_t = rowsum(in_tkm_fit')
t_fit_t = rowsum(in_t_fit')
od_freight_total = tkm_fit_t + t_fit_t

for (i = 1; i<=f_t; i++){
od_tkm_shares_t[.,:,i) = od_tkm_fit[.,:,i):/sum(sum(od_tkm_fit[.,:,i)));
}

for (i = 1; i<=f_t; i++){
od_road_tkm_fcast[.,:,i) = roadfreight_tkm_fcast(i)*od_tkm_shares_t[.,:,i);
od_freight_fcast[.,:,i) = freight_vol_fcast(i)*od_tkm_shares_t[.,:,i);
}
 
for (i = 1; i<=TL; i++){
    out_road_tkm[.,i) = squeeze(sum(od_road_tkm_fcast[.,:,i),2));
    out_freight_tkm[.,i) = squeeze(sum(od_freight_fcast[.,:,i),2));
}

for (i = 1; i<=TL; i++){
   in_road_tkm[.,i) = squeeze(sum(od_road_tkm_fcast[.,:,i),2));
   in_freight_tkm[.,i) = squeeze(sum(od_freight_fcast[.,:,i),2));
}

geo2model = 1..9

reg_tkm_geoorder = in_road_tkm' + out_road_tkm'
reg_tkm = reg_tkm_geoorder
for (i = 1; i<=12; i++){
reg_tkm[.,i] = reg_tkm_geoorder[.,geo2model[.,i));
}


road_share = reg_roadfreight_fcast:/(reg_roadfreight_fcast+
                reg_railfreight_fcast+reg_seafreight_fcast)
rail_share = reg_railfreight_fcast:/(reg_roadfreight_fcast+
                reg_railfreight_fcast+reg_seafreight_fcast)
sea_share = reg_seafreight_fcast:/(reg_roadfreight_fcast+
                reg_railfreight_fcast+reg_seafreight_fcast)

reg_roadfreight_fcast = road_share:*reg_tkm
reg_railfreight_fcast = rail_share:*reg_tkm
reg_seafreight_fcast = sea_share:*reg_tkm
*/
end
